#!/usr/bin/perl
#
# BlueLava v0.4.3
# (c) 2001-2004  Ian Wilkinson (ian@sgtwilko.f9.co.uk)
#
# Released under the GPL v2... see COPYING for details
# This software comes without any warranty...
#

@backends =("heyu","x10d","bottlerocket","ppower","flipit","wish");

#Print an input box to enter colour value
sub html_Color
{
	local($help_text, $varName) = @_;
	print "<tr><td>$help_text</td><td><input type=\"text\" name=\"$varName\" length=6 maxlength=6 size=6 value=\"$config_settings{\"$varName\"}\"></td></tr>";	
}

#Print the option list of rooms and select the room
sub html_optionRoomList
{
	local($currentRoom,$optName) = @_;
	print "<select name=\"$optName\"><input type=\"option\" name=\"$optName\">";
	foreach $room (sort keys %config_rooms)
	{
		print "<option value=\"$room\"";
		if ($room eq $currentRoom)
		{
			print " selected";
		}
		print ">$room</option>";
	}
	print "<option value=\"delete\"";
	if ($room eq "delete"){
		print " selected";
	}
	print ">Delete</option>";
	print "</select>";
}

#Print the option list of unit types
sub html_optionUnitTypeList
{
	local($currentType, $optName) = @_;
	print "<select name=\"$optName\"><input type=\"option\" name=\"$optName\">";
	print "<option value=\"lamp\"";
	if ($currentType eq "lamp") {
		print " selected";
	}
	print ">Lamp</option><option value=\"appliance\"";
	if ($currentType eq "appliance"){
		print " selected";
	}
	print ">Appliance</option></select>";
}

#Print unit line
sub html_unitLine
{
	local($device,$deviceNo,$room) =@_;
	%devicehash = %$device;
	print "<tr><td><input type=\"text\" value=\"$devicehash{\"id\"}\" name=\"id$deviceNo\" length=\"3\" maxlength=\"3\" size=\"3\"></td>";
	print "<td>";
	html_optionUnitTypeList($devicehash{"type"},"type$deviceNo");
	print "</td>";
	print "<td><input type=\"text\" value=\"$devicehash{\"name\"}\" name=\"name$deviceNo\"></td>";
	print "<td>";
	html_optionRoomList($room,"room$deviceNo");
	print "</td></tr>";
}

#Show admin page
sub html_admin_page
{
	print "Content-type: text/html\n\n";
	html_header();
	if ((CGI->remote_addr() eq "127.0.0.1")) {
		local($header_color_fg) = $config_settings{header_color_fg};
		local($header_color_bg) = $config_settings{header_color_bg};
		local ($status_color_fg) = $config_settings{"status_color_fg"};
		local ($status_color_bg) = $config_settings{"status_color_bg"};
		if ($admin==1) {
			html_admin_room();
		} elsif ($admin==2) {
			html_admin_settings();
		}
	} else {
		print "You are not authorised to view this page.";
	}
	html_footer();
}

#Show room setup
sub html_admin_room {
local(%devicehash, $currentroom, $room);
	@allParams=param();
	$requireSave=0;
	if (param("roomAdmin") eq "1") {
		foreach $room (sort keys %config_rooms)
		{
			if (! ($room eq param($room)))
			{
				$config_rooms{param($room)}=$config_rooms{$room};
				delete $config_rooms{$room};
				$requireSave=1;
			}	
			if (param("$room\_del") eq "1") {
				delete $config_rooms{$room};
				$requireSave=1;
			}
		}
		if (! (param("new1") eq "")) {
			$config_rooms{param("new1")}="";
			$requireSave=1;
		}
		if (! (param("new2") eq "")) {
			$config_rooms{param("new2")}="";
			$requireSave=1;
		}

	}
	if (! (param("unitAdmin") eq "")) {
		#loop through the rooms and delete all their units?
		#then loop through all the units we've been sent and add those
		# onto rooms?
        	foreach $room (keys %config_rooms)
        	{
			$deviceptr = $config_rooms{$room};
			@$deviceptr =();
        	}
		for ($x=1;$x<=param("unitAdmin");$x++)
		{
			$room = param("room$x");
			if (! ($room eq "delete"))
			{
				my(%devicehash);
				$devicehash{"id"} =  param("id$x");
				$devicehash{"type"} =param("type$x"); 
				$devicehash{"name"} = param("name$x");
				$currentroom=$config_rooms{"$room"};

				@$currentroom = (@$currentroom, \%devicehash);
			}
		}
		$requireSave=1;
	}
	if ($requireSave==1)
	{
		save_Configuration();
	}
	html_table_admin();
	print "<center><table width=\"80%\">";
	print "<tr><td bgcolor=\"#$header_color_bg\" colspan=4><center><font color=\"#$header_color_fg\"><b>Room Setup</b></font></center></td></tr>\n";
	print "<tr><td colspan=4>To remove a room, check the delete box next to the room name.  You can delete as many rooms as you want at any time.  Please note that all units in a room will be removed.  If you want to keep those units, you will have to move them to another room first.<br><br>If you want to add a room, two blank lines have been left for that purpose.  You can not add more than 2 rooms at a time.  If you want to add a room and add units, you will have to add the room Before you add units</td></tr>";
	print "<tr><td colspan=3 bgcolor=\"#$header_color_bg\"><center><font color=\"#$header_color_fg\">Room Name</font></center></td><td bgcolor=\"#$config_settings{\"label_actions_bg\"}\"><center><font color=\"#$config_settings{\"label_actions_fg\"}\">Delete</font></center></td></tr>";
	print "<form name=\"roomNames\" action=\"$bluelava_url/bluelava.cgi\" method=\"POST\"><input type=\"hidden\" name=\"admin\" value=\"$admin\"><input type=\"hidden\" name=\"roomAdmin\" value=\"1\">";
	foreach $room (sort keys %config_rooms)
	{
		print "<tr><td colspan=3><input type=\"Text\" name=\"$room\" value=\"$room\"></td><td><input type=\"checkbox\" name=\"$room\_del\" value=\"1\"></td></tr>";
	}
	print "<tr><td colspan=3><input type=\"Text\" name=\"new1\" value=\"\"></td></tr><tr><td colspan=3><input type=\"Text\" name=\"new2\" value=\"\"></td></tr><tr><td colspan=3> </td><td><input type=\"submit\" value=\"Save Rooms\"></td></tr></form>";
	print "<tr><td colspan=4 bgcolor=\"#$header_color_bg\"><center><font color=\"#$header_color_fg\">Unit Setup</font></center></td></tr>";
	print "<tr><td colspan=4>To remove a unit select \"Delete\" as it's room.  To Add a unit, fill out one of the blank lines at the end of the list of units.<br><br>If you leave any device without a Unit Code or a description will be ignored and therefore deleted.</td></tr>"; 
	print "<tr><td bgcolor=\"$config_settings{\"label_device_bg\"}\"><center><font color=\"$config_settings{\"label_device_fg\"}\">Unit Code</font></center></td><td bgcolor=\"#$config_settings{\"label_type_bg\"}\"><center><font color=\"#$config_settings{\"label_type_fg\"}\">Type</font></center></td><td bgcolor=\"#$config_settings{\"label_device_bg\"}\"><center><font color=\"#$config_settings{\"label_device_fg\"}\">Description</font></center></td><td bgcolor=\"#$header_color_bg\"}\"><center><font color=\"#$header_color_fg\">Room</font></center></td></tr>";
	print "<form name=\"units\" action=\"$bluelava_url/bluelava.cgi\" method=\"POST\"><input type=\"hidden\" name=\"admin\" value=\"$admin\"><tr><td>";
	$deviceNo=1;
	foreach $room (sort keys %config_rooms)
	{
		$deviceptr = $config_rooms{$room};
		@devicelist = @$deviceptr;
		foreach $device (@devicelist)
		{
			html_unitLine($device, $deviceNo++, $room);
		}
	}
	html_unitLine($device, $deviceNo++, "delete");
	html_unitLine($device, $deviceNo, "delete");
	print "<input type=\"hidden\" value=\"$deviceNo\" name=\"unitAdmin\"><tr><td colspan=3> </td><td><input type=\"submit\" value=\"Save Units\"></td></tr></form>";
	print "<tr><td colspan=4 bgcolor=\"#$status_color_bg\" align=left>";
	print "<font size=\"-1\" color=\"#$status_color_fg\">$bluelava_version</font>";
	print "</td></tr>";
	print "</table></center>";
}

#Show Settings
sub html_admin_settings
{
	@allParams=param();
	$requireSave=0;
	foreach $paramName (@allParams)
	{
		foreach $Config (keys %config_settings)
		{
			if ($Config eq $paramName)
			{
				$config_settings{$Config}=param($Config);
				$requireSave=1;
			}
		}
	}
	if ($requireSave==1)
	{
		save_Configuration();
	}
	html_table_admin();
	print "<center><table width=\"80%\">";
	print "<tr><td bgcolor=\"#$header_color_bg\" colspan=2><center><font color=\"#$header_color_fg\"><b>BlueLava Settings</b></font></center></td></tr><tr><td colspan=2>Here you can change the settings that BlueLava uses to access your hardware and control the look of BlueLava.<br>You can also change the Device and Room configuration from here.</td></tr>\n";
	print "<tr><td bgcolor=\"#$header_color_bg\" colspan=2><center><font color=\"#$header_color_fg\"><b>X10 Backend</b></font></center></td></tr>";
	#open (FILELOC, "which heyu|");
	#$myStuff=<FILELOC>;
	print "<form name=\"BackendSelector\" action=\"$bluelava_url/bluelava.cgi\" method=\"GET\"><tr><td>Backend:</td><td><input type=hidden name=\"admin\" value=\"$admin\"><select name=\"backend\" size=\"1\">";
	print "<input type=option name=backend>";
	foreach $backend (@backends)
	{
		if ($backend eq $config_settings{"backend"})
		{
			$selected="selected=\"selected\"";
		}
		else
		{
			$selected="";
		}
		print "<option value=\"$backend\" $selected>$backend<br></option>\n";
	}
	print "</select></td></tr><tr><td></td><td align=\"right\"><input type=\"submit\" value=\"Save Backend\"></td></tr></form>\n<tr><td colspan=2>&nbsp; </td></tr><tr><td bgcolor=\"#$header_color_bg\" colspan=2><center><font color=\"#$header_color_fg\"><b>Backend Settings</b></font></center></td></tr><form name=\"BackendSettings\" action=\"$bluelava_url/bluelava.cgi\" method=\"GET\"><input type=hidden name=\"admin\" value=\"$admin\">\n";
	foreach $settingName (keys %config_settings)
	{
		if ($config_settings{"backend"} eq substr($settingName,0,length($config_settings{"backend"})))
		{
			print "<tr><td>$settingName</td><td><input type=text name=\"$settingName\" value=\"$config_settings{\"$settingName\"}\"></td></tr>";
		}
	}
	print "<tr><td></td><td align=\"right\"><input type=\"submit\" value=\"Save Settings\"></td></tr><tr><td colspan=2>&nbsp;</td></tr><tr><td bgcolor=\"#$header_color_bg\" colspan=2><center><font color=\"#$header_color_fg\"><b>BlueLava settings</b></font></center></<td></tr>";
	html_Color("Default Text Colour","default_text_color");
	html_Color("Default Text dimmed Colour","default_text_dimmed");
	html_Color("Default Row Colour","default_row_color");
	html_Color("Status Colour Forground","status_color_fg");
	html_Color("Status Colour Background","status_color_bg");
	html_Color("Action Forground","label_actions_fg");
	html_Color("Action Background","label_actions_bg");
	html_Color("Device Forground","label_device_fg");
	html_Color("Device Background","label_device_bg");
	html_Color("Device Type Forground","label_type_fg");
	html_Color("Device Type Background","label_type_bg");
	html_Color("Header Colour Forground","header_color_fg");
	html_Color("Header Colour Background","header_color_bg");
	print "<tr><td>Use the Colour Gradient</td><td><select name=\"table_use_gradient\"><input type=\"option\" name=\"table_use_gradient\">";
	$yes="";
	$no="selected=\"selected\"";
	if ($config_settings{table_use_gradient} eq "yes")
	{
		$yes=$no;
		$no="";
	}
	print "<option value=\"yes\" $yes>Yes</option>";
	print "<option value=\"no\" $no>No</option>";
	print "</select></td></tr>";
	#colorop
	$yes="";
	$no="selected=\"selected\"";
	if ($config_settings{table_gradient_colorop} eq "subtract")
	{
		$yes=$no;
		$no="";
	}
	print "<tr><td>Colour Gradient Mode</td><td><select name=\"table_gradient_colorop\"><input type=\"option\" name=\"table_gradient_colorop\">";
	print "<option value=\"add\" $no>Add</option>";
	print "<option value=\"subtract\" $yes>Subtract</option>";
	print "</select></td></tr>";
	html_Color("Gradient Start Colour","table_gradient_start");
	html_Color("Gradient Change Amount","table_gradient_colorchange");
	print "<tr><td colspan=2 align=\"right\"><input type=\"submit\" value=\"Save Settings\"></td></tr></form>";
        print "<tr><td colspan=2 bgcolor=\"#$status_color_bg\" align=left>";
        print "<font size=\"-1\" color=\"#$status_color_fg\">$bluelava_version</
font>";
        print "</td></tr>";
	print "</table></center>";
}


# end of admin.pl
1;
